#version 300 es
#ifdef GL_FRAGMENT_PRECISION_HIGH
  precision highp float;
#else
  precision mediump float;
#endif

layout (location = 0) in vec4 vPosition;
layout (location = 1) in vec2 vTexCoord;
out vec2 texCoord;

uniform mat4 mM; // into world coordinate system
uniform mat4 mV; // into camera coordinate system
uniform mat4 mPV; // perspective * view
uniform mat4 mRotations; // all the rotations

void main()
{
    gl_Position = mPV * mM * vPosition;
    texCoord = vTexCoord;
}
