#version 300 es
#ifdef GL_FRAGMENT_PRECISION_HIGH
  precision highp float;
#else
  precision mediump float;
#endif

layout (location = 0) in vec4 vPosition;
layout (location = 1) in vec4 vNormal;
layout (location = 2) in vec2 vTexCoord;

// 2d 1 - 999
const int typeSingleColor         =    1;
const int typeText                =    2;
const int typeTextAlpha           =    3;
const int typeDurationBackground  =  100;
const int typePalmMuteBackground  =  101;
const int typeBend                =  102;
const int typeVibrato             =  103;
const int typeTremolo             =  104;
const int typePHBackground        =  105;
const int typeSlide               =  106;
const int typeHudPreviewBackground=  200;
const int typeImage               =  700;
const int typeDraggable           =  801;
const int typeLock                =  802;
const int typeLibraryBackground   =  901;
const int typeLibraryButtonBack   =  902;
const int typeHudButtonBack       =  903;
//3d 1000 - ....
const int type3d                  = 1000;
const int typeSingleColor3d       = 1001;
const int typeBarline3d           = 1009;
const int typeFretboardFret3d     = 1010;
const int typeFretboardString3d   = 1011;
const int typeFretboardInlays     = 1012;
const int typeChord3dEmptyString  = 1101;
const int typeChord3dNote         = 1102;
const int typeChord3dNoteHarmonic = 1103;
const int typeChord3dNoteMute     = 1104;
const int typeChord3dNotePalmMute = 1105;
const int typeChord3dNoteHammeron = 1106;
const int typeChord3dNotePulloff  = 1107;
const int typeChord3dGhostNote    = 1108;
const int typeChord3dBase         = 1109;
const int typeChord3dNoteSustain  = 1110;
const int typeChord3dFlare        = 1111;
const int typeChord3dPalmMute     = 1112;

uniform lowp int objType;

uniform mat4 mM; // into world coordinate system
uniform mat4 mV; // into camera coordinate system
uniform mat4 mPV; // perspective * view
uniform mat4 mRotations; // all the rotations
uniform vec4 vLight;

out vec2 texCoord;
out vec3 fN;
out vec3 fL;
out vec3 fE;
out vec4 vShadowCoord;
out vec4 vPos;

void main()
{
    vPos = mM * vPosition;
    gl_Position = mPV * vPos;
    texCoord = vTexCoord;

    if(objType >= type3d) {
        fN = (mRotations*vNormal).xyz;
        fL = (vLight).xyz;
        fE = (mV*mM*vPosition).xyz;
        texCoord = vTexCoord;
    }
}