#version 300 es
#ifdef GL_FRAGMENT_PRECISION_HIGH
  precision highp float;
#else
  precision mediump float;
#endif

out vec4 FragColor;
uniform sampler2D texSampler;
uniform vec4 color;
uniform vec4 background;
in vec2 texCoord;

void main()
{
    vec4 low = texture(texSampler, vec2(texCoord.x, 0.0f));
    vec4 hi = texture(texSampler, vec2(texCoord.x, 1.0f));

    if( texCoord.y >= low.g + low.r/256.0f && texCoord.y <= hi.g + hi.r/256.0f)
    {
        FragColor = color;
    }
    else
    {
        FragColor = background;
    }
}


